import { Link, useLocation } from 'react-router-dom'
import { Sparkles } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <Sparkles size={36} strokeWidth={2.5} className="logo-icon" />
              <span className="logo-text">CostumeRent</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои аренды
              </Link>
              <Link 
                to="/rent" 
                className={`nav-link ${location.pathname === '/rent' ? 'active' : ''}`}
              >
                Арендовать
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

